<#
 
 Script to get new/missing UWPs for the Remove-UWP.ps1 configuration XML
 Best use on a blank Feature Release installed without internet!
 
 ALWAYS DOUBLECHECK the result for system packages!!!
 They usually MUST NOT be removed, so never put them in the configuration XML!

 Author: Michael Zier <michael.zier@mahe.at>

 Version: 1.0.0

 Changelog:
  2019-03-19: initial Version
#>
#requires -version 3.0
Param(
    [Parameter(Mandatory=$false, HelpMessage='Config XML')][string] $Xml = '.\Remove-UWP.xml',
    [Parameter(Mandatory=$false, HelpMessage='Output File')][string] $Out = '.\new.txt'
)

$arrExclude = @(
    'Microsoft.NET.Native.',
    'Microsoft.VCLibs.',
    'Microsoft.Advertising.Xaml',
    'Microsoft.VP9VideoExtensions',
    'Microsoft.WebpImageExtension',
    'Microsoft.WebMediaExtensions',
    'Microsoft.Services.Store.Engagement',
    'Microsoft.HEIFImageExtension',
    'Microsoft.StorePurchaseApp',
    'Microsoft.DesktopAppInstaller',
    'Microsoft.WindowsStore',
    'Microsoft.UI.Xaml.',
    'Microsoft.MPEG2VideoExtension'
)


if (-not (Test-Path -Path $Xml -PathType Leaf -ErrorAction SilentlyContinue)) {
    Write-Host "$Xml not found!" -ForegroundColor Red -BackgroundColor Black
    Exit 3
}
try {
    $Current = ([xml](Get-Content -Path $Xml)).mz.UWP.Item.Name
}
catch {
    Write-Host "Error reading $Xml!" -ForegroundColor Red -BackgroundColor Black
    Exit 1603
}

if (Test-Path -Path $Out -PathType Leaf -ErrorAction SilentlyContinue) {
    Remove-Item -Path $out -Force -Confirm:$false
}

$objUWPs = Get-AppxPackage | Where-Object NonRemovable -ne $true | Select-Object -ExpandProperty Name

foreach ($UWP in $objUWPs) {
    if ($Current -notcontains $UWP) {
        $arrExclude | %{ if ($UWP -like "$_*") { continue } }
        if (-not $check) {
            Write-Host $UWP -ForegroundColor Yellow -BackgroundColor Black
            Add-Content -Path $Out -Value "        <Item Name=`"$UWP`" Action=`"CHANGEME`" />"
        }
    }
}

Write-Host "Output: $out" -ForegroundColor Green -BackgroundColor Black